/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.demos.action;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Arrays;
import oracle.install.commons.base.interview.common.action.AbstractSummaryAction;
import oracle.install.commons.base.summary.Category;
import oracle.install.commons.base.summary.Percentage;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.base.summary.Variable;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.demos.bean.DemosInstallSettings;
import oracle.install.library.partition.PartitionInfoUnix;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.StageSizeInfo;

public class SummaryAction
extends AbstractSummaryAction {
    private static final DecimalFormat DISK_SPACE_FORMATTER = new DecimalFormat(".##");

    protected void buildSummary(FlowContext flowContext) {
        DemosInstallSettings installSettings = (DemosInstallSettings)((Object)flowContext.getBean(DemosInstallSettings.class));
        CentralInventorySettings cenInv = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
        AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)flowContext.getBean(AutoUpdatesInstallSettings.class);
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.ivw.demos.resource.DemosDialogLabelResID");
        Summary summary = Summary.getInstance();
        summary.clear();
        summary.setTitle("Summary");
        summary.setDescription(application.getName());
        String description = resource.getString("INSTALL_DEMOS_SUMMARY_GLOBAL_SETTING_CATEGORY", "Global settings.", new Object[0]);
        Category globalSettingsCategory = new Category("GlobalSettings", description);
        summary.addCategory(globalSettingsCategory);
        try {
            boolean considerOracleHomeOffset = false;
            long reqSpace = StageSizeInfo.getSize((String)"DB", (boolean)considerOracleHomeOffset);
            String oracleHomeFolder = SummaryAction.getLastExistingParent(installSettings.getOracleHome());
            long freeSpace = PartitionInfoUnix.getPartitionFreeSpace((String)oracleHomeFolder);
            int requiredPercentage = 100;
            if (freeSpace > reqSpace) {
                requiredPercentage = (int)Math.round(100.0 * (double)reqSpace / (double)freeSpace);
            }
            String stringTotalSpace = this.readableSpace(freeSpace);
            String stringReqSpace = this.readableSpace(reqSpace);
            String message = resource.getString("INSTALL_DEMOS_SUMMARY_DISK_SPACE_REQUIRED", "required {0} available {1}", new Object[]{stringReqSpace, stringTotalSpace});
            description = resource.getString("INSTALL_DEMOS_SUMMARY_DISK_SPACE", "Disk space", new Object[0]);
            globalSettingsCategory.addVariable(new Variable("requiredPercentage", description, (Object)new Percentage(requiredPercentage, message), this.isTraversableStateId(flowContext, "getOracleHome") ? "getOracleHome" : ""));
        }
        catch (InstallException e) {
            // empty catch block
        }
        String fromLoc = FunctionsUtil.pathify((String)installSettings.getProductDescriptorLocation());
        description = resource.getString("INSTALL_DEMOS_SUMMARY_TITLE_SOURCE_LOC", "Source location", new Object[0]);
        Variable sourceVar = new Variable("Source", description, (Object)fromLoc);
        globalSettingsCategory.addVariable(sourceVar);
        description = resource.getString("INSTALL_DEMOS_SUMMARY_TYPE_LABEL", "Installation Type:", new Object[0]);
        String installTypeString = resource.getString("INSTALL_DEMOS_SUMMARY_TYPE", "Oracle Database Examples", new Object[0]);
        Variable installType = new Variable("installType", description, (Object)installTypeString);
        globalSettingsCategory.addVariable(installType);
        description = resource.getString("INSTALL_DEMOS_SUMMARY_TITLE_ORACLE_BASE", "Oracle Base:", new Object[0]);
        Variable oracleBaseVar = new Variable("OracleBase", description, (Object)installSettings.getOracleBase(), this.isTraversableStateId(flowContext, "getOracleHome") ? "getOracleHome" : "");
        globalSettingsCategory.addVariable(oracleBaseVar);
        description = resource.getString("INSTALL_DEMOS_SUMMARY_TITLE_ORACLE_HOME", "Oracle Home name:", new Object[0]);
        Variable oracleHomevar = new Variable("OracleHome", description, (Object)installSettings.getOracleHome(), this.isTraversableStateId(flowContext, "getOracleHome") ? "getOracleHome" : "");
        globalSettingsCategory.addVariable(oracleHomevar);
        Object[] nodesArr = installSettings.getListOfSelectedNodes();
        if (nodesArr != null && nodesArr.length > 0) {
            StringBuffer strNodes = new StringBuffer();
            strNodes.append(Arrays.toString(nodesArr).substring(1, Arrays.toString(nodesArr).length() - 1));
            description = resource.getString("INSTALL_DEMOS_SUMMARY_TITLE_CLUSTER_NODES", "RAC Nodes", new Object[0]);
            Variable clusterNodesVar = new Variable("clusterNodesVar", description, (Object)strNodes, this.isTraversableStateId(flowContext, "nodeSelectionPage") ? "nodeSelectionPage" : "");
            globalSettingsCategory.addVariable(clusterNodesVar);
        }
        if (!InventoryInfo.getInstance().isInventoryExist()) {
            description = resource.getString("INSTALL_DEMOS_SUMMARY_INVENTORY_CATEGORY", "Inventory information", new Object[0]);
            Category inventoryDetail = new Category("inventoryDetail", description);
            summary.addCategory(inventoryDetail);
            description = resource.getString("INSTALL_DEMOS_SUMMARY_INVENTORY_LOCATION", "Inventory location.", new Object[0]);
            Variable invLoc = new Variable("invLoc", description, (Object)cenInv.getInventoryLocation(), this.isTraversableStateId(flowContext, "inventoryPage") ? "inventoryPage" : "");
            inventoryDetail.addVariable(invLoc);
            if (!PlatformInfo.getInstance().isWindows()) {
                description = resource.getString("INSTALL_CLIENT_SUMMARY_OPER_GROUP", "oraInventory group", new Object[0]);
                Variable groupVarOper = new Variable("oper", description, (Object)cenInv.getGroupOwnership(), this.isTraversableStateId(flowContext, "inventoryPage") ? "inventoryPage" : "");
                inventoryDetail.addVariable(groupVarOper);
            }
        }
        PatchDownloadType downloadType = autoBean.getDownloadType();
        if (autoBean.isApplyUpdates() && downloadType != null) {
            Application app = Application.getInstance();
            Resource r = app.getResource(AutoUpdatesDialogLabelResID.class.getName());
            description = r.getString("AUTO_UPDATES_OPTION_DESC", "Software updates option", new Object[0]);
            String value = r.getString((Enum)autoBean.getDownloadType(), new Object[0]);
            Variable autoUpdatesOptionsVar = new Variable("AutoUpdatesOption", description, (Object)value, this.isTraversableStateId(flowContext, "AutoUpdatesOptionsUI") ? "AutoUpdatesOptionsUI" : "");
            globalSettingsCategory.addVariable(autoUpdatesOptionsVar);
            if (autoBean.getDownloadType() == PatchDownloadType.OFFLINE_UPDATES) {
                description = r.getString("AUTO_UPDATES_DOWNLOAD_LOC", "Pre-downloaded software updates location", new Object[0]);
                Variable autoUpdatesLoc = new Variable("AutoUpdatesDownloadLoc", description, (Object)autoBean.getPatchDownloadLocation(), this.isTraversableStateId(flowContext, "AutoUpdatesOptionsUI") ? "AutoUpdatesOptionsUI" : "");
                globalSettingsCategory.addVariable(autoUpdatesLoc);
            }
        }
    }

    private String readableSpace(long space) {
        String stringSpace = "";
        if ((float)space < 1024.0f) {
            stringSpace = space + " MB";
        } else {
            stringSpace = DISK_SPACE_FORMATTER.format((float)space / 1024.0f);
            stringSpace = stringSpace + " GB";
        }
        return stringSpace;
    }

    public static String getLastExistingParent(String inputPath) {
        File f = new File(inputPath);
        if (f.exists() && f.isDirectory()) {
            return inputPath;
        }
        return SummaryAction.getLastExistingParent(f.getParent().toString());
    }
}

